<?php


use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\ApiController;
use App\Http\Controllers\Api\UserController;


/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});



Route::get('/get_auth_code', [ApiController::class, 'getAuthCode']);
Route::post('/get_access_token', [ApiController::class, 'getAccessToken']);
Route::get('/refresh_access_token', [ApiController::class, 'refreshAccessToken']);
Route::post('/create_meeting', [ApiController::class, 'createMeeting']);
Route::get('/view_meeting', [ApiController::class, 'viewMeeting']);


Route::group(
    ['middleware' => 'auth:api'],
    function () {
        
        
    }
);

