@extends('layouts.admin')
@section('title', $t)
@section('content')
<div class="main-content">
    <section class="section">
        <div class="section-header">
            <h1>{{ $t }}</h1>
            <div class="section-header-breadcrumb">
                <div class="breadcrumb-item active"><a href="{{ route('home') }}">{{ __('Dashboard') }}</a></div>
                <div class="breadcrumb-item"><a href="{{ route('settings') }}">{{ __('Settings') }}</a></div>
                <div class="breadcrumb-item">{{ $t }}</div>
            </div>
        </div>
        <div class="section-body">
            <h2 class="section-title">{{ __('All About') }} {{ $t }}</h2>
            <p class="section-lead">
                {{ __('You can adjust all') }} {{ $t }} {{ __('here') }}
            </p>
            <div id="output-status"></div>
            <div class="row">
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header">
                            <h4>{{ __('Jump To') }}</h4>
                        </div>
                        <div class="card-body">
                            <ul class="nav nav-pills flex-column">
                                <li class="nav-item"><a href="{{ route('setting', 'app-setting') }}"
                                        class="nav-link ">{{ __('App Setting') }}</a></li>
                                <li class="nav-item"><a href="{{ route('setting', 'storage-setting') }}"
                                        class="nav-link active">{{ __('Storage') }}</a></li>
                                <li class="nav-item"><a href="{{ route('setting', 'mail-setting') }}"
                                        class="nav-link">{{ __('Email') }}</a></li>
                                <li class="nav-item"><a href="{{ route('setting', 'chat-setting') }}"
                                        class="nav-link">{{ __('Chat') }}</a></li>
                                <li class="nav-item"><a href="{{ route('setting', 'general-setting') }}"
                                        class="nav-link">{{ __('General') }}</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-md-8">
                    <form id="setting-form" action="{{ route('settings/s3-setting/update') }}"
                        enctype="multipart/form-data" method="POST">
                        @csrf
                        <div class="card" id="settings-card">
                            <div class="card-header">
                                <h4> {{ $t }}</h4>
                            </div>
                            <div class="card-body">
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <label for="status_toggle">{{ __('Local') }}</label>
                                        <label class="custom-radio col-3 mt-2 ">
                                            <input name="settingtype" class="custom-switch-input" type="radio"
                                            value="local" checked
                                            {{ Utility::getsettings('settingtype') == 'local' ? 'checked' : 'unchecked' }}>
                                            <span class="custom-switch-indicator"></span>
                                        </label>
                                        <label for="status_toggle">{{ __('S3 setting') }}</label>
                                        <label class="custom-radio col-3 mt-2 ">
                                            <input name="settingtype" class="custom-switch-input" type="radio"
                                            value="s3"
                                            {{ Utility::getsettings('settingtype') == 's3' ? 'checked' : 'unchecked' }}>
                                            <span class="custom-switch-indicator"></span>
                                        </label>
                                    </div>
                                </div>
                                <div id="s3" class="desc {{ Utility::getsettings('settingtype') == 's3' ? 'block' : 'd-none' }}">
                                    <p class="text-muted"> {{ __('S3 Setting') }}</p>
                                    <div class="">
                                        <div class="row">
                                            <div class="col-lg-12">
                                                <div class="form-group">
                                                    <label for="s3_key">{{ __('S3 Key') }}</label>
                                                    <input type="text" name="s3_key" class="form-control"
                                                        value="{{ Utility::getsettings('s3_key') }}"
                                                          placeholder="{{ __('S3 Key') }}">
                                                </div>
                                            </div>
                                            <div class="col-lg-12">
                                                <div class="form-group">
                                                    <label for="s3_secret">{{ __('S3 Secret') }}</label>
                                                    <input type="text" name="s3_secret" class="form-control"
                                                        value="{{ Utility::getsettings('s3_secret') }}"
                                                          placeholder="{{ __('S3 Secret') }}">
                                                </div>
                                            </div>
                                            <div class="col-lg-12">
                                                <div class="form-group">
                                                    <label for="s3_region">{{ __('S3 Region') }}</label>
                                                    <input type="text" name="s3_region" class="form-control"
                                                        value="{{ Utility::getsettings('s3_region') }}"
                                                          placeholder="{{ __('S3 Region') }}">
                                                </div>
                                            </div>
                                            <div class="col-lg-12">
                                                <div class="form-group">
                                                    <label for="s3_bucket">{{ __('S3 Bucket') }}</label>
                                                    <input type="text" name="s3_bucket" class="form-control"
                                                        value="{{Utility::getsettings('s3_bucket') }}"
                                                          placeholder="{{ __('S3 Bucket') }}">
                                                </div>
                                            </div>
                                            <div class="col-lg-12">
                                                <div class="form-group">
                                                    <label for="s3_url">{{ __('S3 URL') }}</label>
                                                    <input type="text" name="s3_url" class="form-control"
                                                        value="{{ Utility::getsettings('s3_url') }}"
                                                          placeholder="{{ __('S3 URL') }}">
                                                </div>
                                            </div>
                                            <div class="col-lg-12">
                                                <div class="form-group">
                                                    <label for="s3_endpoint">{{ __('S3 Endpoint') }}</label>
                                                    <input type="text" name="s3_endpoint" class="form-control"
                                                        value="{{ Utility::getsettings('s3_endpoint') }}"
                                                          placeholder="{{ __('S3 Endpoint') }}">
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer bg-whitesmoke text-md-right">
                                <button class="btn btn-primary" type="submit" id="save-btn">{{ __('Save Changes') }}</button>
                                <a href="{{ route('settings') }}" class="btn btn-secondary">{{ __('Cancel') }}</a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection
@push('javascript')
<script>
    // $("input[name='settingtype']").click(function() {
        $(document).on('click',"input[name='settingtype']",function(){
        var test = $(this).val();

        if (test == 's3') {
            $("#s3").fadeIn(500);
            $("#s3").removeClass('d-none');
        } else {
            $("#s3").fadeOut(500);
            
        }
    });
</script>
@endpush
