@extends('layouts.admin')
@section('title')
{{ __('Members') }}
@endsection

@section('content')
<div class="page-content-wrapper">
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="page-title-box">

                    <h3>Edit product</h3>

                </div>
            </div>
        </div>
        {!! Form::model($user, ['method' => 'PATCH', 'route' => ['products.update', $user->id],'enctype'=>"multipart/form-data"]) !!}
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12 mb-2">
                                <div class="form-group">
                                    <label>name<span style="color:red !important;">*</span></label>
                                    {!! Form::text('name', null, ['placeholder' => __('Name'), 'class' => 'form-control']) !!}
                                </div>
                            </div>



                            <div class="col-12 mb-2">
                                <div class="form-group">
                                    <label>Price<span style="color:red !important;">*</span></label>
                                    {!! Form::number('price', null, ['placeholder' => __('Price'),'step'=>'any', 'class' => 'form-control']) !!}
                                </div>
                            </div>


                            <div class="col-12 mb-2">
                                <div class="form-group">
                                    <label>Quntity<span style="color:red !important;">*</span></label>
                                    {!! Form::text('qty', null, ['placeholder' => __('Enter Qty'), 'class' => 'form-control']) !!}
                                </div>
                            </div>

                            <div class="col-12 mb-3">

                                <label>Product LOGO and carousel display pictures<span style="color:red !important;">*</span></label>
                                <p class="text-muted mb-4 font-13"><img src="{{ Storage::url('uploads/product/'.$user->image) }}"></p>
                                <input type="file" name="image" id="input-file-now" class="dropify" />

                            </div>







                        </div>

                        <button type="submit" class="btn btn-success waves-effect waves-light">Save Product</button>
                        <a href="{{ route('product_list') }}" class="btn btn-danger waves-effect waves-light">Cancel Edit</a>
                    </div>
                </div>

            </div>
            <!-- end row -->
        </div>
        {!! Form::close() !!}
        <!-- container -->
    </div>
    <!-- Page content Wrapper -->
</div>



@endsection

@push('css')
@endpush
@push('javascript')
<!-- <script src="{{ asset('assets/admin/lib/jquery/jquery-3.7.1.min.js') }}"></script> -->
<!-- <script src="{{ asset('assets/admin/lib/datatables/dataTables.js') }}"></script> -->


@endpush