@extends('layouts.admin')
@section('title')
{{ __('Order') }}
@endsection

@section('content')
<div class="page-content-wrapper">
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="page-title-box">



                    <h4 class="page-title mt-2">Order List</h4>

                </div>
            </div>
        </div>



        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="mt-0 d-none header-title">Conditional search</h4>
                        <div class="row d-none">
                            <div class="col-6 mb-3">
                                <h6 class="input-title mt-2">Enter User Name</h6>
                                <input type="text" class="form-control" maxlength="25" name="username" id="search_username" placeholder="Enter user name" />
                            </div>
                            <div class="col-6 mb-3">
                                <h6 class="input-title mt-2">Enter Phone Number</h6>
                                <input type="text" class="form-control" maxlength="25" name="mobile_number" id="search_mobile_number" placeholder="Enter phone number" />
                            </div>
                            <div class="col-6 mb-3">
                                <h6 class="input-title mt-2">Select Registration Date</h6>
                                <input type="date" class="form-control" maxlength="25" name="r_date" id="search_r_date" />
                            </div>
                            <div class="col-6 mt-3">
                                <div class="btn-group float-right">

                                    <button type="button" id="filter" class="btn btn-primary waves-effect mb-3">Search Data</button>

                                </div>
                            </div>

                        </div>
                        <div class="table-responsive py-4">
                            {{ $dataTable->table(['width' => '100%']) }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="exampleModal02" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST" action="{{ route('incress-decress-amount') }}">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Plus Deduction</h5>

                </div>
                <div class="modal-body">
                    <h6 class="input-title mt-2"> User Name</h6>
                    <input type="text" readonly="readonly" class="form-control" maxlength="25" name="username" id="user_name" placeholder="Enter user name" />


                    <h6 class="input-title mt-2">Increase</h6>


                    <select name="type" class="form-control">
                        <option value="">Select</option>
                        <option value="credit">Increase</option>
                        <option value="debit">Deduct</option>
                    </select>

                    <h6 class="input-title mt-2"> Amount</h6>
                    <input type="number" class="form-control" maxlength="25" name="amount" id="amount" placeholder="Enter Amount" />


                </div>
                <div class="modal-footer">
                    <input type="hidden" name="user_id" id="user_id" value="0">
                    <button type="submit" class="btn btn-primary">Submit</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>

                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@push('css')
<link rel="stylesheet" href="{{ asset('assets/admin/lib/datatables/dataTables.css') }}">
@include('layouts.includes.datatable_css')
@endpush
@push('javascript')
<!-- <script src="{{ asset('assets/admin/lib/jquery/jquery-3.7.1.min.js') }}"></script> -->
<!-- <script src="{{ asset('assets/admin/lib/datatables/dataTables.js') }}"></script> -->
@include('layouts.includes.datatable_js')
<script>
    $(document).ready(function() {
        $(document).on("click", "#filter", function() {
            getData();
        });




        window.LaravelDataTables = null;

        function getData() {
            if (window.LaravelDataTables == null) {
                window.LaravelDataTables = $("#users-table").DataTable({
                    "serverSide": true,
                    "processing": true,
                    "ajax": {
                        "url": "{{ route('order_list') }}",
                        "type": "GET",
                        "data": function(data) {
                            for (var i = 0, len = data.columns.length; i < len; i++) {
                                if (!data.columns[i].search.value) delete data.columns[i].search;
                                if (data.columns[i].searchable === true) delete data.columns[i]
                                    .searchable;
                                if (data.columns[i].orderable === true) delete data.columns[i]
                                    .orderable;
                                if (data.columns[i].data === data.columns[i].name) delete data
                                    .columns[i]
                                    .name;
                            }
                            delete data.search.regex;
                            data.username = $("#search_username").val();
                            data.mobile_number = $("#search_mobile_number").val();
                            data.r_date = $("#search_r_date").val();
                        }
                    },
                    "columns": [{
                        "data": "id",
                        "name": "id",
                        "title": "Order Number",
                        "orderable": true,
                        "searchable": true
                    }, {
                        "data": "username",
                        "name": "username",
                        "title": "Username",
                        "orderable": true,
                        "searchable": true
                    }, {
                        "data": "finish_start",
                        "name": "finish_start",
                        "title": "Finish/Start",
                        "orderable": true,
                        "searchable": true
                    }, {
                        "data": "product_name",
                        "name": "product_name",
                        "title": "Product Name",
                        "orderable": true,
                        "searchable": true
                    }, {
                        "data": "price",
                        "name": "price",
                        "title": "Price",
                        "orderable": true,
                        "searchable": true
                    }, {
                        "data": "num_of_transaction",
                        "name": "num_of_transaction",
                        "title": "Num Of Transaction",
                        "orderable": true,
                        "searchable": true
                    }, {
                        "data": "commission",
                        "name": "commission",
                        "title": "Commission",
                        "orderable": true,
                        "searchable": true
                    }, {
                        "data": "created_at",
                        "name": "created_at",
                        "title": "Created At",
                        "orderable": true,
                        "searchable": true
                    }, {
                        "data": "action",
                        "name": "action",
                        "title": "Action",
                        "orderable": false,
                        "searchable": false,
                        "width": 200,
                        "className": "text-center"
                    }],
                    "language": {
                        "paginate": {
                            "next": "<i class=\"fas fa-angle-right\"><\/i>",
                            "previous": "<i class=\"fas fa-angle-left\"><\/i>"
                        }
                    },
                    "scrollX": true
                });
            } else {
                window.LaravelDataTables.ajax.reload();
            }
        }
        getData();

    });
</script>
@endpush