@php
$user = \Auth::user();

@endphp


<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link rel="stylesheet" href="{{ asset('assets/front/css/index.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/front/css/header.css') }}">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/css/bootstrap.min.css" crossorigin="anonymous">
    <link rel="stylesheet" href="{{ asset('assets/modules/izitoast/css/iziToast.min.css ') }}">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/js/bootstrap.min.js" crossorigin="anonymous"></script>
    <link rel="stylesheet" href="{{ asset('assets/front/css/header.css') }}">
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100..900&display=swap" rel="stylesheet">
    <link
    href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css"
    rel="stylesheet"
  />
  <link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css">

    <title>@yield('title') | {{ Utility::getsettings('app_name') }}</title>
    @stack('css')
</head>
<script src="https://chat.titantravel.live/js/min/jquery.min.js"></script>
<script id="sbinit" src="https://chat.titantravel.live/js/main.js"></script>


<!-- End of LiveChat code -->



<body>


<header class="bg-[#081E3F] text-white hidden  text-opacity-80 lg:flex justify-between items-center md:px-12 lg:px-20 pb-2">
        <!-- Left Section -->
        <div class="text-xs flex items-center gap-1">
            Part of the TTC Family of Brands 
            <!-- <span class="ml-2 text-xs">&#9662;</span> -->
            <svg class="h-3 opacity-80 fill-white" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 48 48"  data-src="/assets/shared/icons/UI-arrow1-down.svg"><defs><clipPath id="clip-path-98"><rect x="4" y="4" width="40" height="40" fill="none"></rect></clipPath></defs><g clip-path="url(#clip-path-98)"><path d="M24,28.35,8.92,13.18a2.88,2.88,0,0,0-4.08,0,2.93,2.93,0,0,0,0,4.11l17,17.06a2.82,2.82,0,0,0,2.18.84,2.82,2.82,0,0,0,2.18-.84l17-17.06a2.93,2.93,0,0,0,0-4.11,2.88,2.88,0,0,0-4.08,0Z"></path></g></svg>
        </div>

        <!-- Right Section -->
        <div class="flex items-center  space-x-4">
            <a href="#" class="text-xs hover:underline">FAQs</a>
            <div class="flex items-center text-xs gap-1">
                <span>MyInsight</span>
                <!-- <span class="ml-1 text-xs">&#9662;</span> -->
                <svg class="h-3 opacity-80 fill-white" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 48 48"  data-src="/assets/shared/icons/UI-arrow1-down.svg"><defs><clipPath id="clip-path-98"><rect x="4" y="4" width="40" height="40" fill="none"></rect></clipPath></defs><g clip-path="url(#clip-path-98)"><path d="M24,28.35,8.92,13.18a2.88,2.88,0,0,0-4.08,0,2.93,2.93,0,0,0,0,4.11l17,17.06a2.82,2.82,0,0,0,2.18.84,2.82,2.82,0,0,0,2.18-.84l17-17.06a2.93,2.93,0,0,0,0-4.11,2.88,2.88,0,0,0-4.08,0Z"></path></g></svg>
            </div>
            <a href="#" class="text-xs hover:underline">Brochures</a>
            <a href="#" class="text-xs hover:underline">Advisor Area</a>
            <a href="#" class="text-xs hover:underline">Contact Us</a>
            <a href="#" class="bg-[#C8102E] text-white font-bold text-xs py-2 px-4 hover:opacity-90">GET A QUOTE</a>
        </div>
    </header>

    <!-- Integrated Navigation Bar -->
    <nav class="bg-[#081E3F] text-white flex items-center p-2 justify-between md:px-12 lg:px-20 py-3">
        <!-- Left Section -->
        <div class="sidebar h-dvh overflow-y-scroll" id="sidebar">
          <div class="sidebar-header">
            <img src="https://via.placeholder.com/150x40" alt="Logo">
            <button class="absolute top-4 min-w-6 h-6 right-4 text-white bg-red-500 rounded-full text-md flex items-start justify-center hover:bg-red-600" onclick="toggleSidebar()">X</button>
          </div>


      @if($user)
          <div class="profile">
          <img src="{{ asset('assets/img/' . $user->avatar) }}" alt="Profile Picture" class="w-20 h-20 rounded-full object-cover">
    
            <div class="name text-black">{{$user->username}}</div>
            <div class="referral">Referral Code: {{$user->referral_code}}</div>
            <div class="progress-bar mt-2">
              <span></span>
            </div>
          </div>
      
          <div class="account-info">
            <div>
              <div class="text-2xl font-bold">${{$user->balance}}</div>
              <div class="text-sm">Account Balance</div>
            </div>
            <div>
              <div class="text-2xl font-bold">${{$user->total_commission}}</div>
              <div class="text-sm">Commission</div>
            </div>
          </div>
          @endif
      
          <ul class="menu">
          @if($user) <li><a href="{{route('rate.trip')}}"><i class="fas fa-clipboard-list"></i>Rate Your Trip</a></li> @endif
            <li><a href="{{route('terms')}}"><i class="fas fa-clipboard-list"></i> T&C</a></li>
            <li><a href="{{route('team')}}"><i class="fas fa-users"></i> Team</a></li>
            <li><a href="{{route('faqs')}}"><i class="fas fa-question-circle"></i> FAQs</a></li>
            <li><a href="{{route('about')}}"><i class="fas fa-info-circle"></i> About Us</a></li>
            @if($user)  <li><a href="{{route('deposite')}}"><i class="fas fa-credit-card"></i> Recharge</a></li> @endif
            @if($user)  <li><a href="{{route('withdraw')}}"><i class="fas fa-university"></i> Withdrawal</a></li> @endif
            <!-- <li><a href="#"><i class="fas fa-share-alt"></i> Referral Code</a></li> -->
            @if($user)  <li><a href="{{route('journey.history')}}"><i class="fas fa-history"></i> History</a></li> @endif
            @if($user)  <li><a href="{{route('change.password.form')}}"><i class="fas fa-key"></i> Change Password</a></li> @endif
          </ul>
        </div>
      
        <!-- Main Content -->
        
        <div class="flex items-center space-x-10">
          <div class="flex items-center gap-2">
              <button class="  text-white rounded" onclick="toggleSidebar()"><img class="h-6" src="./assets/images/menu-bar.png" alt="menubar"></button>
              <div class="text-lg font-bold tracking-wide">INSIGHT VACATIONS</div>
          </div>
            <div class="2xl:flex space-x-4 hidden pr-2">
                <div class="relative group flex items-center gap-1">
                    <span class="hover:underline text-sm whitespace-nowrap">DESTINATIONS</span>
                    <!-- <span class="ml-1">&#9662;</span> -->
                    <svg class="h-3 opacity-80 fill-white " xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 48 48"  data-src="/assets/shared/icons/UI-arrow1-down.svg"><defs><clipPath id="clip-path-98"><rect x="4" y="4" width="40" height="40" fill="none"></rect></clipPath></defs><g clip-path="url(#clip-path-98)"><path d="M24,28.35,8.92,13.18a2.88,2.88,0,0,0-4.08,0,2.93,2.93,0,0,0,0,4.11l17,17.06a2.82,2.82,0,0,0,2.18.84,2.82,2.82,0,0,0,2.18-.84l17-17.06a2.93,2.93,0,0,0,0-4.11,2.88,2.88,0,0,0-4.08,0Z"></path></g></svg>
                </div>
                <div class="relative group flex items-center gap-1">
                    <span class="hover:underline text-sm whitespace-nowrap">WAYS TO TRAVEL</span>
                    
                    <svg class="h-3 opacity-80 fill-white " xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 48 48"  data-src="/assets/shared/icons/UI-arrow1-down.svg"><defs><clipPath id="clip-path-98"><rect x="4" y="4" width="40" height="40" fill="none"></rect></clipPath></defs><g clip-path="url(#clip-path-98)"><path d="M24,28.35,8.92,13.18a2.88,2.88,0,0,0-4.08,0,2.93,2.93,0,0,0,0,4.11l17,17.06a2.82,2.82,0,0,0,2.18.84,2.82,2.82,0,0,0,2.18-.84l17-17.06a2.93,2.93,0,0,0,0-4.11,2.88,2.88,0,0,0-4.08,0Z"></path></g></svg>
                </div>
                <div class="relative group flex items-center gap-1">
                    <span class="hover:underline text-sm whitespace-nowrap">SPECIAL OFFERS</span>
                    <!-- <span class="ml-1">&#9662;</span> -->
                    <svg class="h-3 opacity-80 fill-white " xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 48 48"  data-src="/assets/shared/icons/UI-arrow1-down.svg"><defs><clipPath id="clip-path-98"><rect x="4" y="4" width="40" height="40" fill="none"></rect></clipPath></defs><g clip-path="url(#clip-path-98)"><path d="M24,28.35,8.92,13.18a2.88,2.88,0,0,0-4.08,0,2.93,2.93,0,0,0,0,4.11l17,17.06a2.82,2.82,0,0,0,2.18.84,2.82,2.82,0,0,0,2.18-.84l17-17.06a2.93,2.93,0,0,0,0-4.11,2.88,2.88,0,0,0-4.08,0Z"></path></g></svg>
                </div>
                <div class="relative group flex items-center gap-1">
                    <span class="hover:underline text-sm whitespace-nowrap">ABOUT US</span>
                    <!-- <span class="ml-1">&#9662;</span> -->
                    <svg class="h-3 opacity-80 fill-white " xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 48 48"  data-src="/assets/shared/icons/UI-arrow1-down.svg"><defs><clipPath id="clip-path-98"><rect x="4" y="4" width="40" height="40" fill="none"></rect></clipPath></defs><g clip-path="url(#clip-path-98)"><path d="M24,28.35,8.92,13.18a2.88,2.88,0,0,0-4.08,0,2.93,2.93,0,0,0,0,4.11l17,17.06a2.82,2.82,0,0,0,2.18.84,2.82,2.82,0,0,0,2.18-.84l17-17.06a2.93,2.93,0,0,0,0-4.11,2.88,2.88,0,0,0-4.08,0Z"></path></g></svg>
                </div>
            </div>
        </div>

        <!-- Right Section -->
        <div class="flex items-center space-x-6">
            <!-- Search Bar -->
            <div class="relative max-w-44 md:w-full bg-[#F2F3F5] flex-1 text-white rounded-full flex items-center pl-4 pr-2 py-1">
                <input
                    type="text"
                    placeholder="Search our tours"
                    class="bg-transparent w-4/5 outline-none text-sm text-black placeholder-gray-500"
                />
                <div class="h-8 w-8 bg-[#081E3F] rounded-full flex items-center justify-center">
                    <svg
                    xmlns="http://www.w3.org/2000/svg"
                    fill="none"
                    viewBox="0 0 24 24"
                    stroke-width="2"
                    stroke="currentColor"
                    class="w-6 h-6 text-white"
                >
                    <path
                        stroke-linecap="round"
                        stroke-linejoin="round"
                        d="M11 4a7 7 0 100 14 7 7 0 000-14zm10 16l-4.35-4.35"
                    />
                </svg>
                </div>
            </div>

            <!-- Customer and Agent Links -->
            <div class="text-xs text-end hidden lg:flex border-r-2 pr-3 space-x-2">
    @if(!$user)
        <span class="font-semibold cursor-pointer agent_login">Customers</span>
        <br>
        <span class="font-light opacity-80 text-[10px]">Agents</span>
    @else
     <a href="{{route('logout')}}"><span class="font-semibold cursor-pointer">Logout</span></a>
    @endif
</div>


            <!-- Contact Details -->
            <div class="text-xs space-y-1">
                <div class=" hidden lg:flex items-center justify-end ">
                    <svg class="h-4 mr-1 fill-white" xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 48 48" xmlns:xlink="http://www.w3.org/1999/xlink"><path d="M42.91,33.36l-5.58-5.59a3.72,3.72,0,0,0-6.18,1.4,3.8,3.8,0,0,1-4.39,2.39c-4-1-9.37-6.18-10.36-10.37a3.6,3.6,0,0,1,2.39-4.38,3.71,3.71,0,0,0,1.39-6.18L14.6,5.05a4,4,0,0,0-5.38,0L5.43,8.83c-3.79,4,.4,14.56,9.77,23.93s19.94,13.75,23.92,9.77l3.79-3.79A4,4,0,0,0,42.91,33.36Z"></path></svg>
                    <span class="hidden lg:flex">65 6922 5950</span>
                </div>
                <div class="hidden lg:flex items-center justify-end space-x-2">
                    <svg class="h-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 52 53" fill="none" class="injected-svg icon" data-src="/assets/shared/icons/whatsapp-with-background.svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                        <g clip-path="url(#clip0_6153_96686-314)" filter="url(#filter0_d_6153_96686-315)">
                        <path d="M47.8666 25.9333C47.8666 37.9731 38.1064 47.7333 26.0666 47.7333C14.0268 47.7333 4.2666 37.9731 4.2666 25.9333C4.2666 13.8935 14.0268 4.1333 26.0666 4.1333C38.1064 4.1333 47.8666 13.8935 47.8666 25.9333Z" fill="#25D366"></path>
                        <path d="M15.8669 41.1999C15.8669 38.2544 13.479 35.8665 10.5335 35.8665C7.58801 35.8665 5.2002 38.2544 5.2002 41.1999C5.2002 44.1454 7.58801 46.5332 10.5335 46.5332C13.479 46.5332 15.8669 44.1454 15.8669 41.1999Z" fill="#25D366"></path>
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M43.0061 9.00873C38.4945 4.49133 32.4941 2.00229 26.1008 2C12.9268 2 2.20513 12.7205 2.20054 25.898C2.19825 30.1105 3.29953 34.2223 5.39092 37.8459L2 50.2315L14.6698 46.9081C18.1604 48.8128 22.0911 49.8155 26.0905 49.8167H26.1008C39.2725 49.8167 49.9955 39.0949 50 25.9175C50.0023 19.5311 47.5189 13.5273 43.0061 9.00988V9.00873ZM26.1008 45.7805H26.0928C22.5288 45.7795 19.0325 44.8213 15.982 43.0119L15.2566 42.5811L7.73787 44.5532L9.74445 37.2224L9.27231 36.4707C7.28405 33.3079 6.2332 29.6521 6.23549 25.8992C6.24008 14.9471 15.1511 6.03609 26.1089 6.03609C31.4147 6.03839 36.402 8.10687 40.1527 11.8622C43.9035 15.6164 45.9673 20.6083 45.9651 25.9152C45.9604 36.8684 37.0495 45.7795 26.1008 45.7795V45.7805ZM36.9967 30.9036C36.3996 30.6045 33.4637 29.1605 32.9159 28.9612C32.3681 28.7617 31.9705 28.6621 31.5728 29.2603C31.1752 29.8585 30.0304 31.2039 29.682 31.6015C29.3336 32.0003 28.9852 32.0496 28.3881 31.7504C27.7912 31.4513 25.8671 30.8211 23.5855 28.7869C21.8104 27.2032 20.6116 25.2483 20.2633 24.65C19.9149 24.0519 20.2267 23.7287 20.5245 23.4319C20.7927 23.1637 21.1216 22.734 21.4207 22.3856C21.7199 22.0372 21.8184 21.7875 22.0177 21.3897C22.2172 20.9909 22.1175 20.6427 21.9685 20.3435C21.8195 20.0444 20.6255 17.1049 20.1269 15.9097C19.6421 14.7455 19.1495 14.9036 18.7839 14.8841C18.4355 14.8669 18.0379 14.8635 17.6391 14.8635C17.2403 14.8635 16.5939 15.0125 16.0461 15.6107C15.4984 16.2088 13.9559 17.6539 13.9559 20.5921C13.9559 23.5304 16.0955 26.3713 16.3945 26.7701C16.6936 27.1689 20.6059 33.2001 26.5959 35.7877C28.0204 36.4031 29.1331 36.7709 30.0005 37.046C31.4308 37.5009 32.7325 37.4368 33.7616 37.2832C34.9088 37.1113 37.2947 35.8381 37.792 34.4435C38.2893 33.0488 38.2893 31.8524 38.1404 31.6037C37.9915 31.3551 37.5927 31.2049 36.9956 30.9059L36.9967 30.9036Z" fill="white"></path>
                        </g>
                        <defs>
                        <filter id="filter0_d_6153_96686-315" x="0" y="0" width="52" height="52.2666" filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                        <feFlood flood-opacity="0" result="BackgroundImageFix"></feFlood>
                        <feColorMatrix in="SourceAlpha" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha"></feColorMatrix>
                        <feOffset></feOffset>
                        <feGaussianBlur stdDeviation="1"></feGaussianBlur>
                        <feColorMatrix type="matrix" values="0 0 0 0 0.156863 0 0 0 0 0.156863 0 0 0 0 0.156863 0 0 0 0.12 0"></feColorMatrix>
                        <feBlend mode="normal" in2="BackgroundImageFix" result="effect1_dropShadow_6153_96686"></feBlend>
                        <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_6153_96686" result="shape"></feBlend>
                        </filter>
                        <clipPath id="clip0_6153_96686-314">
                        <rect width="48" height="48.2667" fill="white" transform="translate(2 2)"></rect>
                        </clipPath>
                        </defs>
                        </svg>
                      
                    <span class="hidden lg:flex">65 8121 6065</span>
                </div>
                <div class="text-[8px] hidden lg:flex">Or contact your travel advisor</div>
            </div>
        </div>
    </nav>

    <!-- ------------ banner header---------- -->
    <div class=" flex justify-center items-center  min-h-16">
        <div class=" py-2 px-4 flex items-center justify-center flex-wrap text-center space-x-2 text-sm font-semibold text-gray-700">
          <span>INSIGHT VACATIONS IS RATED</span>
          <span class="text-black font-bold">4.6 / 5</span>
          <div class="flex items-center space-x-1 text-yellow-400">
            <!-- Stars -->
            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="currentColor" viewBox="0 0 24 24">
              <path d="M12 .587l3.668 7.568L24 9.764l-6 5.843 1.415 8.281L12 18.767l-7.415 4.121L6 15.607 0 9.764l8.332-1.609L12 .587z"/>
            </svg>
            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="currentColor" viewBox="0 0 24 24">
              <path d="M12 .587l3.668 7.568L24 9.764l-6 5.843 1.415 8.281L12 18.767l-7.415 4.121L6 15.607 0 9.764l8.332-1.609L12 .587z"/>
            </svg>
            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="currentColor" viewBox="0 0 24 24">
              <path d="M12 .587l3.668 7.568L24 9.764l-6 5.843 1.415 8.281L12 18.767l-7.415 4.121L6 15.607 0 9.764l8.332-1.609L12 .587z"/>
            </svg>
            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="currentColor" viewBox="0 0 24 24">
              <path d="M12 .587l3.668 7.568L24 9.764l-6 5.843 1.415 8.281L12 18.767l-7.415 4.121L6 15.607 0 9.764l8.332-1.609L12 .587z"/>
            </svg>
            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24">
              <path d="M12 .587l3.668 7.568L24 9.764l-6 5.843 1.415 8.281L12 18.767l-7.415 4.121L6 15.607 0 9.764l8.332-1.609L12 .587z"/>
            </svg>
          </div>
          <span>BASED ON 40,000+ VERIFIED REVIEWS</span>
          <span class="text-gray-500">|</span>
          <span class="font-bold text-gray-800 flex items-center">
            feefo
            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 ml-1 text-yellow-400" fill="currentColor" viewBox="0 0 24 24">
              <circle cx="6" cy="12" r="5"/>
              <circle cx="18" cy="12" r="5"/>
            </svg>
          </span>
        </div>
      </div>


    <!-- @include('front.include.header') -->


    @yield('content')

    @include('front.include.menu')







    @include('front.include.login-signup')



    @include('front.include.footer')




    <script src="{{ asset('assets/front/js/custom.js') }}"></script>
    <script src="{{ asset('assets/front/js/header.js') }}"></script>

    <script src="{{ asset('assets/modules/izitoast/js/iziToast.min.js') }}"></script>





    <script>
        @if(!$user)
        $(document).on('click', '.agent_login', function() {
            $('#login-popup').show();
        });

        document.addEventListener("DOMContentLoaded", function() {

            //$('#login-popup').show();
            // Get references to the login and register sections
            var loginSection = document.querySelector('.login-section');
            var registerSection = document.querySelector('.register-section');

            registerSection.style.display = 'none';

            document.querySelector('.login').addEventListener('click', function() {
                loginSection.style.display = 'none';
                registerSection.style.display = 'block';
            });

            document.querySelector('.register').addEventListener('click', function() {
                loginSection.style.display = 'block';
                registerSection.style.display = 'none';
            });


        });
        @endif

        @if(session('errors'))
        iziToast.error({
            title: "{{ __('Error!') }}",
            message: "{{ session('errors')->first() }}",
            position: 'topRight'
        });
        @endif

        @if(session('error'))
        iziToast.error({
            title: "{{ __('Error!') }}",
            message: "{{ session('error') }}",
            position: 'topRight'
        });
        @endif

        @if(session('successful'))
        iziToast.success({
            title: "{{ __('Success ') }}",
            message: "{{ session('successful ') }}",
            position: 'topRight'
        });
        @endif

        @if(session('success'))
        iziToast.success({
            title: "{{ __('Success') }}",
            message: "{{ session('success') }}",
            position: 'topRight'
        });
        @endif


        $(".close-btn").click(function () {
            

$('#login-popup').hide();

})
    </script>
      <script>    

const destinations = {
  europe: [
    { name: "Switzerland", image: "./assets/images/switzerland.webp" },
    { name: "Italy", image: "./assets/images/italy.webp" },
    { name: "Spain", image: "./assets/images/spain.webp" },
    { name: "Croatia", image: "./assets/images/croatia.webp" },
    { name: "Iceland", image: "./assets/images/iceland.webp" },
    { name: "Germany", image: "./assets/images/germany.webp" },
    { name: "France", image: "./assets/images/france.webp" },
    { name: "Austria", image: "./assets/images/austria.webp" },
  ],
  asia: [
    { name: "India", image: "./assets/images/india.webp" },
    { name: "Turkey", image: "./assets/images/turkey.webp" },
    { name: "Israel", image: "./assets/images/israel.webp" },
    { name: "Sri Lanka", image: "./assets/images/sri-lanka.webp" },
    { name: "Jordan", image: "./assets/images/jordan.webp" },
    { name: "Nepal", image: "./assets/images/nepal.webp" },
  ],
  "uk-ireland": [
    { name: "England", image: "./assets/images/england.webp" },
    { name: "Scotland", image: "./assets/images/scottland.webp" },
    { name: "Ireland", image: "./assets/images/ireland.webp" },
    { name: "Wales", image: "./assets/images/wales.webp" },
  ],
  "usa-canada": [
    { name: "USA", image: "./assets/images/us.webp" },
    { name: "Canada", image: "./assets/images/canada.webp" },
  ],
  "latin-america": [
    { name: "Peru", image: "./assets/images/peru.webp" },
    { name: "Brazil", image: "./assets/images/brazil.webp" },
    { name: "Argentina", image: "./assets/images/argentina.webp" },
    { name: "Chile", image: "./assets/images/chile.webp" },
    { name: "Uruguay", image: "./assets/images/Uru.webp" },
  ],
  "north-africa": [
    { name: "Egypt", image: "./assets/images/egypt.webp" },
    { name: "Morocco", image: "./assets/images/moroco.webp" },
  ],
};

  const tabs = document.querySelectorAll("#regionTabs button");
  const grid = document.getElementById("destinationGrid");
  const viewAllButton = document.getElementById("viewAllButton");

// Existing event listeners for tabs
tabs.forEach((tab) => {
  tab.addEventListener("click", () => {
    // Update active tab styling
    tabs.forEach((t) => t.classList.remove("border-blue-500", "text-blue-500"));
    tab.classList.add("border-b-2", "border-blue-500", "text-blue-500");

    // Get selected region
    const region = tab.getAttribute("data-region");

    // Update destinations
    grid.innerHTML = destinations[region]
      .map(
        (dest) => `
      <div class="relative group">
        <img src="${dest.image}" alt="${dest.name}" class="w-full h-48 object-cover rounded-lg shadow-md">
        <div class="absolute inset-0 bg-black bg-opacity-30 flex items-center justify-center rounded-lg opacity-0 group-hover:opacity-100">
          <span class="text-white font-bold">${dest.name}</span>
        </div>
      </div>
    `
      )
      .join("");

    // Update button text
    viewAllButton.textContent = `VIEW ALL ${region.toUpperCase()} DESTINATIONS`;
  });
});

// Simulate a click on the first tab when the DOM is fully loaded
document.addEventListener("DOMContentLoaded", () => {
  if (tabs.length > 0) {
    tabs[0].click(); // Automatically trigger the first tab's click event
  }
});




// menu bar-


function toggleSidebar() {
  document.getElementById('sidebar').classList.toggle('open');
}


</script>

<script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>
      <script src="script.js"></script>
      <script>
        const swiper = new Swiper(".mySwiper", {
          slidesPerView: 4,
          spaceBetween: 20,
          navigation: {
            nextEl: ".swiper-button-next",
            prevEl: ".swiper-button-prev",
          },
          pagination: {
            el: ".swiper-pagination",
            clickable: true,
          },
          breakpoints: {
            320: { slidesPerView: 1 },
            768: { slidesPerView: 2 },
            1024: { slidesPerView: 3 },
            1280: { slidesPerView: 4 },
          },
        });
      </script>
        <script>
          function toggleSidebar() {
            document.getElementById('sidebar').classList.toggle('open');
          }
        </script>
    @stack('javascript')
</body>

</html>