@php
$user = \Auth::user();
@endphp
@extends('layouts.main')

@section('content')
<!-- <div class="bg-container020 pt-5 pl-3 pr-3 pb-5">
    <div class="m-container p-3 mb-5">
        <div class="row">
            <div class="col-6">
                <p class="v01">Total Views</p>
            </div>
            <div class="col-6">
                <p class="v01">Total Increase</p>
            </div>
            <div class="col-6 mb-4">
                <h5 class="v02">USDT {{ $user->balance }}</h5>
            </div>
            <div class="col-6 mb-4">
                <h5 class="v02">USDT {{ $user->total_commission }}</h5>
            </div>

            <div class="col-6">
                <p class="v01">Total Journey</p>
            </div>
            <div class="col-6">
                <p class="v01">Visited Journeys</p>
            </div>
            <div class="col-6 mb-4">
                <h5 class="v02">{{ $total_journey }}</h5>
            </div>
            <div class="col-6 mb-4">
                <h5 class="v02">{{ $user->visited_journey }}</h5>
            </div>
        </div>
        <div class="d-flex flex-row justify-content-center">
            <a href="{{ route('start.journey') }}" class="text-center pt-3 text-light bat01">Start Journey</a>
        </div>
    </div>
    <h1 class="explore pb-4">Explore Hotels</h1>
    <div class="d-flex flex-row mb-3">
        <img src="{{ asset('assets/front/img/b01.png')}}" class="b001">
        <div class="pl-3">
            <h1 class="explore01">Hotel Europe</h1>
            <p class="p001">Finding a romantic hotel in Singapore is not difficult at all. Shangri-La Hotel is a great choice for travelers</p>
        </div>
    </div>

    <div class="d-flex flex-row mb-3">
        <img src="{{ asset('assets/front/img/b02.png') }}" class="b001">
        <div class="pl-3">
            <h1 class="explore01">Crowne Plaza Dubai, an IHG Hotel</h1>
            <p class="p001">
                Crowne Plaza Dubai is ideally located on Sheikh Zayed Road, directly opposite the Dubai Interna2onal Conven2on Centre
            </p>
        </div>
    </div>

    <div class="d-flex flex-row mb-3">
        <img src="{{ asset('assets/front/img/b03.png')}}" class="b001">
        <div class="pl-3">
            <h1 class="explore01">Shangri-La Hotel</h1>
            <p class="p001">
                Finding a romantic hotel in Singapore is not difficult at all. Shangri-La Hotel is a great choice for travelers
            </p>
        </div>
    </div>
</div> -->


<div class="w-full bg overflow-hidden relative h-[400px] bg-gray-300 flex items-center justify-center">
        <div class="text-center">
            <h1 class="text-5xl md:text-5xl lg:text-8xl text-white font-bold">Rate this journey</h1>
        </div>
        
    </div>

    <!-- Header -->
    <div class="container mx-auto p-4">
        <a href="">
            <h5 class="text-lg text-end px-3 font-semibold text-gray-800 ">Start Journey</h5>
        </a>
        <div class="bg-white p-6 rounded-lg shadow-lg">
            <div class="grid grid-cols-2 gap-4 text-gray-700 font-semibold">
                <div>
                    <p>Total Views</p>
                    <p class="text-lg font-bold">USDT {{ $user->balance }}</p>
                </div>
                <div>
                    <p>Total Increase</p>
                    <p class="text-lg font-bold">USDT {{ $user->total_commission }}</p>
                </div>
                <div>
                    <p>Total Journey</p>
                    <p class="text-lg font-bold">{{ $total_journey }}</p>
                </div>
                <div>
                    <p>Visited Journeys</p>
                    <p class="text-lg font-bold">{{ $user->visited_journey }}</p>
                </div>
            </div>
            <a href="{{ route('start.journey') }}"><button class="w-full mt-4 bg-pink-500 text-white py-2 rounded-lg">Start Journey</button></a>
        </div>

        <h2 class="mt-6 text-lg font-semibold text-gray-800">Explore Hotels</h2>
        <div class="mt-4 space-y-4">
            <div class="flex items-start space-x-4 py-2 border-2 px-4 rounded-lg hover:shadow-md transition-all ">
                <img src="hotel1.jpg" alt="Hotel Europe" class="w-16 h-16 rounded-lg object-cover">
                <div>
                    <p class="text-blue-800 font-semibold">Hotel Europe</p>
                    <p class="text-gray-700 text-sm">Finding a romantic hotel in Singapore is not difficult at all. Shangri-La Hotel is a great choice for travelers.</p>
                </div>
            </div>
            <div class="flex items-start space-x-4 py-2 border-2 px-4 rounded-lg hover:shadow-md transition-all ">
                <img src="hotel2.jpg" alt="Crowne Plaza" class="w-16 h-16 rounded-lg object-cover">
                <div>
                    <p class="text-blue-800 font-semibold">Crowne Plaza Dubai, an IHG Hotel</p>
                    <p class="text-gray-700 text-sm">Crowne Plaza Dubai is ideally located on Sheikh Zayed Road, directly opposite the Dubai International Convention Centre.</p>
                </div>
            </div>
            <div class="flex items-start space-x-4 py-2 border-2 px-4 rounded-lg hover:shadow-md transition-all ">
                <img src="hotel3.jpg" alt="Shangri-La" class="w-16 h-16 rounded-lg object-cover">
                <div>
                    <p class="text-blue-800 font-semibold">Shangri-La Hotel</p>
                    <p class="text-gray-700 text-sm">Finding a romantic hotel in Singapore is not difficult at all. Shangri-La Hotel is a great choice for travelers.</p>
                </div>
            </div>
        </div>
    </div>
@endsection