let openDropdown = null;

function toggleDropdown(event) {
    event.stopPropagation();
    
    if (window.innerWidth < 1200) {
        const dropdownContent = document.querySelector('.hover-menu-container');

        if (dropdownContent.classList.contains('show')) {
            dropdownContent.classList.remove('show'); 
            setTimeout(() => {
                dropdownContent.style.display = 'none'; 
            }, 100); 
            openDropdown = null;
        } else {
            // Close any other dropdowns if they are open
            document.querySelectorAll('.dropdown-content').forEach((content) => {
                content.classList.remove('show'); 
                content.style.display = 'none'; 
            });

            dropdownContent.style.display = 'block'; 
            setTimeout(() => {
                dropdownContent.classList.add('show'); 
            }, 0); 
            openDropdown = dropdownContent;
        }
    }
}

// Add event listener for the menu click to toggle dropdown
document.querySelector('.menu').addEventListener('click', toggleDropdown);

// No need to close the dropdown when clicking outside
// Removed the entire click event listener that closed the dropdown

document.querySelectorAll('.dropdown-title').forEach((title) => {
    title.addEventListener('click', function(event) {
        event.stopPropagation();

        const dropdownContent = this.nextElementSibling; 

        if (dropdownContent === openDropdown) {
            dropdownContent.classList.remove('show'); 
            setTimeout(() => {
                dropdownContent.style.display = 'none'; 
            }, 100); 
            openDropdown = null;
        } else {
            // Close any other dropdowns if they are open
            document.querySelectorAll('.dropdown-content').forEach((content) => {
                content.classList.remove('show'); 
                content.style.display = 'none'; 
            });
            dropdownContent.style.display = 'block'; 
            setTimeout(() => {
                dropdownContent.classList.add('show'); 
            }, 0); 
            openDropdown = dropdownContent;
        }
    });
});
