<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;
use App\Models\User;

class ValidReferralCode implements Rule
{
    public function passes($attribute, $value)
    {
        return User::where('referral_code', $value)->exists();
    }

    public function message()
    {
        return 'The :attribute is not a valid referral code.';
    }
}