<?php

namespace App\Http\Controllers;

use App\DataTables\PartnersDataTable;
use App\DataTables\TransactionDataTable;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User;
use Spatie\Permission\Models\Role;
use DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Arr;
use App\DataTables\UsersDataTable;
use App\DataTables\WithdrawDataTable;
use App\Models\DepositRequest;
use App\Models\RatingHistory;
use App\Models\TravelJourney;
use App\Models\WithdrawRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;
use Faker\Factory as Faker;

use File;
use Notification;
use App\Notifications\SendPushNotification;

class UserController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(UsersDataTable $dataTable)
    {
        $users = User::where('type', 'User')->get();
        return $dataTable->render('users.index', compact('users'));
    }

    function WithdrawReq(WithdrawDataTable $table)
    {
        return $table->render('request.withdraw');
    }

    function transactions(TransactionDataTable $table)
    {
        return $table->render('transaction');
    }

    function manageUsers(UsersDataTable $table)
    {
        return $table->render('users');
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        if (\Auth::user()->can('create-partner')) {
            $roles = Role::where('name', '!=', 'Super Admin')->orderBy('id', 'desc')->pluck('name', 'name')->all();
            return view('users.create', compact('roles'));
        }
    }

    function incressDecressAmount(Request $request)
    {
        $this->validate($request, [
            'amount' => 'required|numeric',
            'type' => 'required',
        ]);

        $user = User::find($request->user_id);
        if ($request->type == 'credit') {
            $user->balance = $user->balance + $request->amount;
        } else {
            $user->balance = $user->balance - $request->amount;
        }
        $user->save();
        return redirect()->route('users.index')
            ->with('success', 'Memeber created successfully');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if (\Auth::user()->can('create-partner')) {

            $this->validate($request, [
                'username' => [
                    'required',
                    'string',
                    'min:3',
                    'max:20',
                    'regex:/^[a-zA-Z0-9_]+$/u', // Only allow alphanumeric characters and underscores
                    Rule::unique('users', 'username'), // Ensure username is unique in the users table
                ],
                'mobile_number' => 'required|unique:users,mobile_number',
                'password' => 'required',
                'redemption_pin' => ['required', 'numeric', 'digits:4'],
                'referral_by' => 'required',

            ]);

            $input = $request->all();
            // $input['real_password'] = $input['password'];


            $faker = Faker::create();
            $dummyName = $faker->name;
            $email = $faker->email;

            $referralCode = $this->generateReferralCode(); // You can adjust the length as needed

            // Ensure the referral code is unique
            while (User::where('referral_code', $referralCode)->exists()) {
                $referralCode = $this->generateReferralCode();
            }

            // $user = User::create($input);
            $user =  User::create([
                'name' => $dummyName,
                'email' => $email,
                'type' => $input['type'],
                'username' => $input['username'],
                'mobile_number' => $input['mobile_number'],
                'redemption_pin' => $input['redemption_pin'],
                'referral_code' => $referralCode,
                'referral_by' => $input['referral_by'],
                'password' => Hash::make($input['password']),
            ]);
            $user->assignRole($input['type']);
            if ($input['type'] == 'User') {

                return redirect()->route('users.index')
                    ->with('success', 'Memeber created successfully');
            } else {
                return redirect()->route('agency_list')
                    ->with('success', 'Agency created successfully');
            }
        }
    }

    function generateReferralCode($length = 6)
    {
        $characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $referralCode = '';

        for ($i = 0; $i < $length; $i++) {
            $referralCode .= $characters[rand(0, strlen($characters) - 1)];
        }

        return strtoupper($referralCode);
    }
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        if (\Auth::user()->can('manage-partner')) {

            $user = User::find($id);
            $products = TravelJourney::all();
            return view('users.show', compact('user', 'products'));
        }
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

     function resetJourney($id){
        $user = User::find($id);
        $user->visited_journey = 0;
        $user->save();
        return redirect()->route('users.index')
        ->with('success', 'User Journey Reset successfully');
     }
    public function edit($id)
    {

        if (\Auth::user()->can('edit-partner')) {
            $user = User::find($id);
            $roles = Role::pluck('name', 'name')->all();
            $users = User::where('type', 'User')->where('id', '!=', $id)->select(DB::raw("CONCAT(id, ' - ', username) AS username"), 'id')
                ->get()
                ->pluck('username', 'id');
            // Fetch all users from the database


            $userRole = $user->roles->pluck('name', 'name')->all();

            return view('users.edit', compact('user', 'roles', 'userRole', 'users'));
        }
    }
    public function bankEdit($id)
    {


        $user = User::find($id);

        return view('users.bank', compact('user'));
    }
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if (\Auth::user()->can('edit-partner')) {
            $this->validate($request, [
                'username' => 'required',
                'mobile_number' => 'required',
                'referral_by' => 'required',

            ]);
            $input = $request->all();


            $user = User::find($id);
            if ($request->password == '') {
                unset($input['password']);
            }
            $user->update($input);


            return redirect()->route('users.index')
                ->with('success', 'User updated successfully');
        }
    }

    public function changeWithStatus($id, $status)
    {
        if (\Auth::user()->can('edit-partner')) {



            $with = WithdrawRequest::find($id);

            if ($status == 'complate') {

                $user = User::find($with->user_id);
                $user->balance = $user->balance - $with->amount;
                $user->save();
            }

            $with->status = $status;
            $with->save();


            return redirect()->route('withdraw_list')
                ->with('success', 'withdraw status updated successfully');
        }
    }
    public function changeDepositeStatus($id, $status)
    {
        if (\Auth::user()->can('edit-partner')) {



            $with = DepositRequest::find($id);
            if ($status == 1) {

                $user = User::find($with->user_id);
                $user->balance = $user->balance + $with->amount;
                $user->save();
            }

            $with->status = $status;
            $with->save();


            return redirect()->route('deposite_list')
                ->with('success', 'deposite status updated successfully');
        }
    }

    public function bankUpdate(Request $request, $id)
    {
        if (\Auth::user()->can('edit-partner')) {
            $this->validate($request, [
                'chain_type' => 'required',
                'address' => 'required',
            ]);
            $input = $request->all();

            $user = User::find($id);
            $input['bank_card_number'] = $request->address;

            $user->update($input);


            return redirect()->route('users.index')
                ->with('success', 'User bank updated successfully');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {

        if (\Auth::user()->can('delete-partner')) {

            if ($id != 1) {

                $user = User::find($id);
                RatingHistory::where('user_id',$user->id)->delete();
                WithdrawRequest::where('user_id', $user->id)->delete();
                DepositRequest::where('user_id', $user->id)->delete();
                User::find($id)->delete();
                return redirect()->route('users.index')
                    ->with('success', 'User deleted successfully');
            } else {
                return redirect()->route('agency_list')
                    ->with('failed', 'Permission denined');
            }
        }
    }

    public function profile()
    {

        $users = \Auth::user();
        return view('users.profile', ['users' => $users]);
    }

    public function editprofile(Request $request)
    {
        $user = \Auth::user();
        $user       = User::findOrFail($user['id']);
        $this->validate(
            $request,
            [
                'name' => 'required|max:120',
                'email' => 'required|email|unique:users,email,' . $user['id'],
            ]
        );
        if ($request->hasFile('profile')) {
            $filenameWithExt = $request->file('profile')->getClientOriginalName();
            $filename        = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            $extension       = $request->file('profile')->getClientOriginalExtension();
            $fileNameToStore = $filename . '_' . time() . '.' . $extension;

            $dir        = storage_path('uploads/avatar');
            $image_path = $dir . $user['avatar'];

            if (File::exists($image_path)) {
                File::delete($image_path);
            }

            if (!file_exists($dir)) {
                mkdir($dir, 0777, true);
            }

            $path = $request->file('profile')->storeAs('uploads/avatar', $fileNameToStore);
        }

        if (!empty($request->profile)) {
            $user['avatar'] = $fileNameToStore;
        }
        $user['name']  = $request['name'];
        $user['email'] = $request['email'];
        $user['level'] = $request['level'];
        $user->save();

        return redirect()->back()->with(
            'success',
            'Profile successfully updated.'
        );
    }


    public function updatePassword(Request $request)
    {
        if (Auth::Check()) {
            $request->validate(
                [
                    'current_password' => 'required',
                    'new_password' => 'required|min:6',
                    'confirm_password' => 'required|same:new_password',
                ]
            );
            $objUser          = Auth::user();
            $request_data     = $request->All();
            $current_password = $objUser->password;
            if (Hash::check($request_data['current_password'], $current_password)) {
                $user_id            = Auth::User()->id;
                $obj_user           = User::find($user_id);
                $obj_user->password = Hash::make($request_data['new_password']);;
                $obj_user->save();

                return redirect()->route('profile', $objUser->id)->with('success', __('Password successfully updated.'));
            } else {
                return redirect()->route('profile', $objUser->id)->with('error', __('Please enter correct current password.'));
            }
        } else {
            return redirect()->route('profile', \Auth::user()->id)->with('error', __('Something is wrong.'));
        }
    }

    function noti()
    {
        return view('users.noti');
    }

    public function saveToken(Request $request)
    {
        auth()->user()->update(['fcm_token' => $request->token]);
        return response()->json(['token saved successfully.']);
    }

    /**
     * Write code on Method
     *
     * @return response()
     */
    public function sendNotification(Request $request)
    {
        $firebaseToken = User::whereNotNull('fcm_token')->pluck('fcm_token')->all();

        $SERVER_API_KEY = 'XXXXXX';

        $data = [
            "registration_ids" => $firebaseToken,
            "notification" => [
                "title" => $request->title,
                "body" => $request->body,
            ]
        ];
        $dataString = json_encode($data);

        $headers = [
            'Authorization: key=' . $SERVER_API_KEY,
            'Content-Type: application/json',
        ];

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);

        $response = curl_exec($ch);

        dd($response);
    }
}
