<?php

namespace App\Http\Controllers;

use App\DataTables\PartnersDataTable;
use App\DataTables\TransactionDataTable;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User;
use Spatie\Permission\Models\Role;
use DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Arr;
use App\DataTables\UsersDataTable;
use App\DataTables\WithdrawDataTable;
use App\Models\DepositRequest;
use App\Models\RatingHistory;
use App\Models\TravelJourney;
use App\Models\WithdrawRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;
use Faker\Factory as Faker;

use File;
use Notification;
use App\Notifications\SendPushNotification;

class ProductController extends Controller
{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
   

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        if (\Auth::user()->can('create-partner')) {
            
            return view('products.create');
        }
    }

    

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if (\Auth::user()->can('create-partner')) {

            $this->validate($request, [
                'name' => 'required',
                'price' => 'required|numeric',
                'qty' => 'required|numeric|min:1',


            ]);
            
            $input = $request->all();
            if ($request->hasFile('image')) {
                $filenameWithExt = $request->file('image')->getClientOriginalName();
                $filename        = pathinfo($filenameWithExt, PATHINFO_FILENAME);
                $extension       = $request->file('image')->getClientOriginalExtension();
                $fileNameToStore = $filename . '_' . time() . '.' . $extension;
                $NameToStore = $filenameWithExt . '_' . time() . '.' . $extension;

               



                $path = $request->file('image')->storeAs('uploads/product', $fileNameToStore);
            }

            if (!empty($request->image)) {
                $input['image'] = $fileNameToStore;
            }



            
             $user =  TravelJourney::create($input);


            return redirect()->route('product_list')
            ->with('success', 'Product created successfully');
        }
    }

    
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
   
    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

        if (\Auth::user()->can('edit-partner')) {
            $user = TravelJourney::find($id);
            return view('products.edit', compact('user'));
        }
    }
   
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        if (\Auth::user()->can('edit-partner')) {
            $this->validate($request, [
                'name' => 'required',
                'price' => 'required|numeric',
                'qty' => 'required|numeric|min:1',
                

            ]);
            $user = TravelJourney::find($id);
            $input = $request->all();
            if ($request->hasFile('image')) {
                $filenameWithExt = $request->file('image')->getClientOriginalName();
                $filename        = pathinfo($filenameWithExt, PATHINFO_FILENAME);
                $extension       = $request->file('image')->getClientOriginalExtension();
                $fileNameToStore = $filename . '_' . time() . '.' . $extension;
                $NameToStore = $filenameWithExt . '_' . time() . '.' . $extension;
                
                $dir        = storage_path('uploads/product');
                $image_path = $dir . $user['iamge'];



                $path = $request->file('image')->storeAs('uploads/product', $fileNameToStore);
            }

            if (!empty($request->image)) {
                $input['image'] = $fileNameToStore;
            }

            
            
            $user->update($input);


            return redirect()->route('product_list')
                ->with('success', 'Product updated successfully');
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {

        if (\Auth::user()->can('delete-partner')) {

            if ($id != 1) {
                $journey = TravelJourney::find($id);
                RatingHistory::where('journey_id', $journey->id)->delete();
                TravelJourney::find($id)->delete();
                return redirect()->route('product_list')
                    ->with('success', 'Product deleted successfully');
            } else {
                return redirect()->route('agency_list')
                    ->with('failed', 'Permission denined');
            }
        }
    }

    public function profile()
    {

        $users = \Auth::user();
        return view('users.profile', ['users' => $users]);
    }

    public function editprofile(Request $request)
    {
        $user = \Auth::user();
        $user       = User::findOrFail($user['id']);
        $this->validate(
            $request,
            [
                'name' => 'required|max:120',
                'email' => 'required|email|unique:users,email,' . $user['id'],
            ]
        );
        if ($request->hasFile('profile')) {
            $filenameWithExt = $request->file('profile')->getClientOriginalName();
            $filename        = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            $extension       = $request->file('profile')->getClientOriginalExtension();
            $fileNameToStore = $filename . '_' . time() . '.' . $extension;

            $dir        = storage_path('uploads/avatar');
            $image_path = $dir . $user['avatar'];

            if (File::exists($image_path)) {
                File::delete($image_path);
            }

            if (!file_exists($dir)) {
                mkdir($dir, 0777, true);
            }

            $path = $request->file('profile')->storeAs('uploads/avatar', $fileNameToStore);
        }

        if (!empty($request->profile)) {
            $user['avatar'] = $fileNameToStore;
        }
        $user['name']  = $request['name'];
        $user['email'] = $request['email'];
        $user->save();

        return redirect()->back()->with(
            'success',
            'Profile successfully updated.'
        );
    }


    public function updatePassword(Request $request)
    {
        if (Auth::Check()) {
            $request->validate(
                [
                    'current_password' => 'required',
                    'new_password' => 'required|min:6',
                    'confirm_password' => 'required|same:new_password',
                ]
            );
            $objUser          = Auth::user();
            $request_data     = $request->All();
            $current_password = $objUser->password;
            if (Hash::check($request_data['current_password'], $current_password)) {
                $user_id            = Auth::User()->id;
                $obj_user           = User::find($user_id);
                $obj_user->password = Hash::make($request_data['new_password']);;
                $obj_user->save();

                return redirect()->route('profile', $objUser->id)->with('success', __('Password successfully updated.'));
            } else {
                return redirect()->route('profile', $objUser->id)->with('error', __('Please enter correct current password.'));
            }
        } else {
            return redirect()->route('profile', \Auth::user()->id)->with('error', __('Something is wrong.'));
        }
    }

    function noti()
    {
        return view('users.noti');
    }

    public function saveToken(Request $request)
    {
        auth()->user()->update(['fcm_token' => $request->token]);
        return response()->json(['token saved successfully.']);
    }

    /**
     * Write code on Method
     *
     * @return response()
     */
    public function sendNotification(Request $request)
    {
        $firebaseToken = User::whereNotNull('fcm_token')->pluck('fcm_token')->all();

        $SERVER_API_KEY = 'XXXXXX';

        $data = [
            "registration_ids" => $firebaseToken,
            "notification" => [
                "title" => $request->title,
                "body" => $request->body,
            ]
        ];
        $dataString = json_encode($data);

        $headers = [
            'Authorization: key=' . $SERVER_API_KEY,
            'Content-Type: application/json',
        ];

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);

        $response = curl_exec($ch);

        dd($response);
    }
}
