<?php

namespace App\Http\Controllers;

use App\DataTables\AgencyDataTable;
use App\DataTables\DepositeDataTable;
use App\DataTables\OrdersDataTable;
use App\DataTables\ProductsDataTable;
use App\DataTables\UsersDataTable;
use App\DataTables\WithdrawDataTable;
use App\Facades\UtilityFacades;
use App\Models\DepositRequest;
use App\Models\RatingHistory;
use App\Models\TravelJourney;
use App\Models\User;
use App\Models\WithdrawRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Rules\AtLeastOneSelected;
use App\Rules\ValidRedemptionPin;
use Illuminate\Support\Facades\DB;
use Traversable;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    function rateTrip()
    {
        $journey =
            DB::table('rating_histories')
            ->select('user_id', DB::raw('SUM(commission) as total_commission'), DB::raw('COUNT(*) as visited_journeys'))
            ->where('user_id', Auth::user()->id)->where('status', 1)
            ->groupBy('user_id')
            ->get();
        // dd($journey);

        $total_journey = 40;
        if(Auth::user()->level != ''){
            $field = 'level_' . Auth::user()->level . '_jorney';
            $total_journey = UtilityFacades::getsettings($field);
        }
        return view('front.rate_tript', compact('journey', 'total_journey'));
    }

    function journeyHistory()
    {

        $all_journey = RatingHistory::where('user_id', Auth::user()->id)->orderBy('created_at', 'desc')->get();
        $pending_journey = RatingHistory::where('user_id', Auth::user()->id)->where('status', 0)->orderBy('created_at', 'desc')->get();
        $complate_journey = RatingHistory::where('user_id', Auth::user()->id)->where('status', 1)->orderBy('created_at', 'desc')->get();
        $hold_journey = RatingHistory::where('user_id', Auth::user()->id)->where('status', 2)->orderBy('created_at', 'desc')->get();
        return view('front.history', compact('all_journey', 'pending_journey', 'complate_journey', 'hold_journey'));
    }

    function lockJourney($id, Request $request)
    {
        // dd($request->all());
        $this->validate($request, [
            'lock_journey' => 'required',
            'current_setting' => 'required',

        ]);
        $journeyData = [];
        foreach ($request->lock_journey as $index => $lockJourney) {
            $journeyData[] = [
                'lock_journey' => $lockJourney,
                'current_setting' => $request->current_setting[$index],
            ];
        }

        // Convert the array to a JSON string
        $journeyJson = json_encode($journeyData);


        $user = User::find($id);
        $user->lock_journey = $journeyJson;
        // $user->selected_journey = $journeyJson;
        $user->save();
        return redirect()->route('users.show', $user->id)->with('success', 'User Lock Succesfully');
    }

    function depositeRequest(Request $request)
    {
        $this->validate($request, [
            'amount' => 'required|numeric',
        ]);

        DepositRequest::create([
            'amount' => $request->amount,
            'user_id' => Auth::user()->id,
            // Add more fields if needed
        ]);

        return redirect()->back()->with('success', 'Deposit request submitted successfully!');
    }


    function withdrawRequest(Request $request)
    {
        $this->validate($request, [
            'amount' => 'required|numeric|min:1',
            'chain_type' => 'required|string',
            'bank_card_number' => 'required|string',
            'redemption_pin' => ['required', new ValidRedemptionPin], // Add redemption pin validation
            // Add more validation rules as needed
        ]);

        if ($request->amount < Auth::user()->balance) {



            $validatedData = $request->all();
            WithdrawRequest::create([
                'user_id' => auth()->user()->id,
                'amount' => $validatedData['amount'],
                'status' => 'pending', // Assuming 'pending' status initially
                'chain_type' => $validatedData['chain_type'],
                'bank_card_number' => $validatedData['bank_card_number'],
                // Add more fields if needed
            ]);


            $user = Auth::user();
            $user->chain_type = $validatedData['chain_type'];
            $user->bank_card_number = $validatedData['bank_card_number'];
            $user->save();

            return redirect()->back()->with('success', 'Withdraw request submitted successfully!');
        } else {
            return redirect()->back()->with('error', 'Insufficient Balance..!');
        }
    }


    function filterJourney(Request $request)
    {
        $minPrice = $request->input('min_price');
        $maxPrice = $request->input('max_price');

        $query = TravelJourney::query();

        if ($minPrice !== null && $maxPrice !== null) {

            $query->whereRaw('price * qty >= ?', [$minPrice]);
            $query->whereRaw('price * qty <= ?', [$maxPrice]);
        }

        $products = $query->get();

        return view('users.filter_list', compact('products'));
    }


    function startJourney()
    {
        $user = Auth::user();
        if ($user->visited_journey >= 40) {
            return redirect()->route('rate.trip')->with('error', 'Your daily limit is over please contact to admin!');
        }

        $rating = RatingHistory::where('user_id', Auth::user()->id)->where('status', '0')->first();
        if (!$rating) {
            $userWalletBalance = Auth::user()->balance;
            if ($user->lock_journey != '') {
                $lock_journey = json_decode($user->lock_journey);

                if ($lock_journey) {
                    $lock_journey_list = array_column($lock_journey, 'lock_journey');
                    $current_setting_list = array_column($lock_journey, 'current_setting');
                    //set lock journey list wise current setting list
                    $lock_journey = array_combine($lock_journey_list, $current_setting_list);
                    // dd($lock_journey);
                    //check $user->visited_journey is in lock journey list
                    if (array_key_exists($user->visited_journey, $lock_journey)) {
                        $lock_setting = $lock_journey[$user->visited_journey];
                        // dd($lock_setting);
                        $randomJourney = TravelJourney::where('id', $lock_setting)->first();
                    } else {
                        $randomJourney = TravelJourney::whereRaw('(price * qty) < ?', [$userWalletBalance])
                            ->inRandomOrder()->first();
                    }
                } else {
                    $randomJourney = TravelJourney::whereRaw('(price * qty) < ?', [$userWalletBalance])
                        ->inRandomOrder()->first();
                    // dd($randomJourney);
                }
            } else {

                $randomJourney = TravelJourney::whereRaw('(price * qty) < ?', [$userWalletBalance])
                    ->inRandomOrder()->first();
            }
            // dd($randomJourney);

            if ($randomJourney) {
                $regular_commision = 0.01;
                $lock_commision = 0.05;
                // Calculate the 1% commission value
                if ($user->lock_journey != '') {
                    $lock_journey = json_decode($user->lock_journey);
                    $lock_journey_list = array_column($lock_journey, 'lock_journey');
                    $current_setting_list = array_column($lock_journey, 'current_setting');
                    //set lock journey list wise current setting list
                    $lock_journey = array_combine($lock_journey_list, $current_setting_list);
                    // dd($lock_journey);
                    //check $user->visited_journey is in lock journey list
                    if (array_key_exists($user->visited_journey, $lock_journey)) {
                        if ($user->level != '') {
                            $field = 'level_' . $user->level . '_commission';
                            $lock_commision = UtilityFacades::getsettings($field) / 100;
                            $commission = round(($randomJourney->price * $randomJourney->qty) * $lock_commision, 2);
                        }

                        $commission = round(($randomJourney->price * $randomJourney->qty) * $lock_commision, 2);
                    } else {
                        $commission = round(($randomJourney->price * $randomJourney->qty) * $regular_commision, 2);
                    }
                } else {

                    $commission = round(($randomJourney->price * $randomJourney->qty) * $regular_commision, 2);
                }


                $price = round($randomJourney->price * $randomJourney->qty, 2);
                $user = Auth::user();

                $login_user = User::find($user->id);
                $login_user->balance = $login_user->balance - $price;
                $login_user->save();



                $history = new RatingHistory();
                $history->user_id = Auth::user()->id;
                $history->journey_id = $randomJourney->id;
                $history->rating = 0;
                $history->commission = $commission;
                $history->save();


                return view('front.review', [
                    'journey' => $randomJourney,
                    'commission' => $commission
                ]);
            } else {
                // No eligible journey found
                return redirect()->route('rate.trip')->with('error', 'Insufficient Balance..!');
            }
        } else {
            // dd($user->lock_journey);
            // No eligible journey found
            return redirect()->route('rate.trip')->with('error', 'Please submit the pending record before proceeding to the next journey.');
        }
    }
    function submitJourney($id, Request $request)
    {
        $journey_id = base64_decode($id);
        $journey = TravelJourney::find($journey_id);
        $ratingjourney = RatingHistory::where('user_id', Auth::user()->id)->where('journey_id', $journey_id)->where('status', '0')->first();
        if ($ratingjourney) {
            if (Auth::user()->balance < 0) {
                return redirect()->back()->with('error', 'Insufficient Balance..!');
            }
            $ratingjourney->rating = ($request->rating) ? $request->rating : 0;
            $ratingjourney->status = 1;
            $ratingjourney->save();

            $price = round($journey->price * $journey->qty, 2);

            $addition = $ratingjourney->commission + $price;

            $user = Auth::user();
            $userdetails = User::find($user->id);
            $userdetails->balance = $userdetails->balance + $addition;
            $userdetails->visited_journey = $userdetails->visited_journey + 1;
            $userdetails->total_commission = $userdetails->total_commission + $ratingjourney->commission;
            $userdetails->save();

            $parentCommission = $ratingjourney->commission * (30 / 100);

            $parent_user = User::find($userdetails->referral_by);
            // dd($parent_user);
            $parent_user->balance = $parent_user->balance + $parentCommission;
            $parent_user->save();

            return redirect()->route('rate.trip')->with('success', 'Review journey succesfully');
        } else {
            return redirect()->back()->with('error', 'Journey not found or already submit');
        }
    }

    function resubmitJourney($id)
    {
        $journey_id = base64_decode($id);
        $randomJourney = TravelJourney::find($journey_id);
        if ($randomJourney) {
            $user = Auth::user();
            // Calculate the 1% commission value
            if ($user->lock_journey != '') {
                $lock_journey = explode(',', $user->lock_journey);
                if (in_array($user->visited_journey, $lock_journey)) {
                    $commission = round(($randomJourney->price * $randomJourney->qty) * 0.05, 2);
                } else {

                    $commission = round(($randomJourney->price * $randomJourney->qty) * 0.01, 2);
                }
            } else {

                $commission = round(($randomJourney->price * $randomJourney->qty) * 0.01, 2);
            }

            return view('front.review', [
                'journey' => $randomJourney,
                'commission' => $commission
            ]);
        } else {
            // No eligible journey found
            return redirect()->back()->with('error', 'Insufficient Balance..!');
        }
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $usercount = User::where('type', 'User')->count();
        $admincount = User::where('type', 'Admin')->count();
        return view('dashboard.home', compact('usercount', 'admincount'));
    }

    public function deposite()
    {

        return view('front.deposite');
    }

    public function depositeHistory()
    {

        $all_request = DepositRequest::where('user_id', Auth::user()->id)->get();
        return view('front.deposite_history', compact('all_request'));
    }
    public function withdraw()
    {

        return view('front.withdraw');
    }

    public function changepasswordform()
    {

        return view('front.changepassword');
    }


    public function changePassword(Request $request)
    {
        // Validate input
        $validator = Validator::make($request->all(), [
            'current_password' => 'required',
            'new_password' => 'required|min:8|confirmed', // You can customize the validation
        ]);

        if ($validator->fails()) {
            return redirect()->route('change.password.form')->withErrors($validator)->withInput();
        }

        // Check if the current password matches
        if (!Hash::check($request->current_password, Auth::user()->password)) {
            return redirect()->route('change.password.form')->withErrors(['current_password' => 'Current password is incorrect'])->withInput();
        }

        // Update password
        Auth::user()->update([
            'password' => Hash::make($request->new_password),
        ]);

        return redirect()->route('change.password.form')->with('success', 'Password updated successfully!');
    }

    public function withdrawHistory()
    {

        $all_request = WithdrawRequest::where('user_id', Auth::user()->id)->get();
        return view('front.withdraw_history', compact('all_request'));
    }

    public function front()
    {

        return view('front.home');
    }


    public function manageWallet()
    {

        return view('front.wallet');
    }

    function order(Request $request)
    {

        $input = $request->all();
        $user = auth()->user();

        $payment = PaytmWallet::with('receive');
        $payment->prepare([
            'order' => $input['order_id'],
            'user' => $input['CUST_ID'],
            'mobile_number' => $user->mobile,
            'email' => $user->email,
            'amount' => $input['amount'],
            'callback_url' => url('api/paytm-payment-status')
        ]);
        return $payment->receive();
    }


    function withdrawList(WithdrawDataTable $table, $user_id  = 0)
    {
        return $table->render('withdraw.index', compact('user_id'));
    }
    function depositeList(DepositeDataTable $table, $user_id = 0)
    {
        return $table->render('deposite.index', compact('user_id'));
    }
    function productList(ProductsDataTable $table)
    {
        return $table->render('products.index');
    }
    function agencyList(AgencyDataTable $table)
    {
        $users = User::where('type', 'Super Admin')->get();
        return $table->render('users.agency', compact('users'));
    }
    function orderList(OrdersDataTable $table)
    {
        return $table->render('orders.index');
    }

    public function join($id)
    {
        $tournament = Tournament::find($id);
        if ($tournament) {
            $user = auth()->user();
            if ($tournament->fees > $user->balance) {
                return redirect('/games/bgmi#upcoming-matches')->with('error', 'Insufficient Balance..!');
            } else {
                $join_details = Tournament_participants::where('match_id', $id)
                    ->where('user_id', $user->id)
                    ->first();
                $participants = Tournament_participants::where('match_id', $id)->get();
                return view('front.tournament-details', compact('tournament', 'join_details', 'participants'));
            }
        } else {
            return redirect()->back()->with('error', 'Tournament Not Exist.');
        }
    }

    function joinTournament(Request $request)
    {
        request()->validate([
            'ign' => 'required',
        ]);

        $user = auth()->user();
        $tournament = Tournament::find($request->match_id);
        if ($tournament) {
            if ($tournament->fees > $user->balance) {
                return redirect('/games/bgmi#upcoming-matches')->with('error', 'Insufficient Balance..!');
            }
            $participant = Tournament_participants::create(['ign' => $request->ign, 'match_id' => $request->match_id, 'user_id' => $user->id]);


            return redirect('/games/bgmi#upcoming-matches')
                ->with('success', __('Join successfully.'));
        } else {
            return redirect()->back()->with('error', 'Tournament Not Exist.');
        }
    }
}
